! Changes the array's PositionPhase and VelocityPhase
! Before, the array's should be the time delay's of the
! movement of the sections relative to the signal
! Afterwards, the array's indicate the phase in radians / pi

SUBROUTINE CalculatePhases
	USE GraphsModule
	USE ParametersModule, ONLY: plotPhase, lGetPhase
	IMPLICIT NONE

	IF (lGetPhase) THEN
		CALL CalculatePhase(PositionPhase)
		CALL CalculatePhase(VelocityPhase)
		CALL CalculateStapesPhase(StapesPositionPhase)
		CALL CalculateStapesPhase(StapesVelocityPhase)
	ENDIF
END SUBROUTINE CalculatePhases

SUBROUTINE CalculatePhase(PhaseArray)
	USE Declare
	USE GraphsModule
	IMPLICIT NONE
	REAL(8), INTENT(INOUT), DIMENSION(0:n_plotpoints - 1) :: PhaseArray
	REAL(8) signalPhase
	INTEGER NoPhaseFound_Index 

	! Positive zero-crossing of signal1 happens every time when time is an integer multiple of signal1's period
	! Therefore, the last positive zero-crossing of signal1 is determined as follows:
	! WARNING: signal1Frequency cannot be 0!
	! modified by HD 06-09-2007
	IF (signal1Frequency > 0) THEN
	    SignalPhase = DBLE(FLOOR(signal1Frequency * t_max)) / signal1Frequency
	ELSE
	    SignalPhase = 0
	ENDIF

	NoPhaseFound_Index = 0
	DO WHILE (NoPhaseFound_Index < (n_plotpoints - 1) .AND. PhaseArray(NoPhaseFound_Index) /= -1)
		NoPhaseFound_Index = NoPhaseFound_Index + 1
	ENDDO

	! Determine phase of <PhaseArray> relative to signal1
	PhaseArray = (signalPhase - PhaseArray) *  signal1Frequency * 2 !* pi	! in radians / pi (so 1 means pi)
	
	! Remove possible jumps of 2pi
	IF (PhaseArray(0) - SignalPhase > 1) PhaseArray = PhaseArray - 2
	IF (PhaseArray(0) - SignalPhase < -1) PhaseArray = PhaseArray + 2

	DO i = 1, NoPhaseFound_Index - 1
		IF (PhaseArray(i) - PhaseArray(i-1) > 1) PhaseArray(i:) = PhaseArray(i:) - 2
		IF (PhaseArray(i) - PhaseArray(i-1) < -1) PhaseArray(i:) = PhaseArray(i:) + 2
	ENDDO

	PhaseArray(NoPhaseFound_Index:) = 1000

END SUBROUTINE CalculatePhase

SUBROUTINE CalculateStapesPhase(StapesPhase)
	USE Declare
	USE GraphsModule
	IMPLICIT NONE
	REAL(8), INTENT(INOUT) :: StapesPhase
	REAL(8) signalPhase
!	INTEGER NoPhaseFound_Index 

	! Positive zero-crossing of signal1 happens every time when time is an integer multiple of signal1's period
	! Therefore, the last positive zero-crossing of signal1 is determined as follows:
	! WARNING: signal1Frequency cannot be 0!
	! modified by HD 06-09-2007
	IF (signal1Frequency > 0) THEN
	    signalPhase = DBLE(FLOOR(signal1Frequency * t_max)) / signal1Frequency
	ELSE
	    signalPhase = 0
	ENDIF

!	NoPhaseFound_Index = 0
!	DO WHILE (NoPhaseFound_Index < (n_plotpoints - 1) .AND. PhaseArray(NoPhaseFound_Index) /= -1)
!		NoPhaseFound_Index = NoPhaseFound_Index + 1
!	ENDDO

	! Determine phase of <PhaseArray> relative to signal1
	StapesPhase = (signalPhase - StapesPhase) *  signal1Frequency * 2 !* pi	! in radians / pi (so 1 means pi)
	
	! Remove possible jumps of 2pi
	IF (StapesPhase - SignalPhase >  1) StapesPhase = StapesPhase - 2
	IF (StapesPhase - SignalPhase < -1) StapesPhase = StapesPhase + 2

!	PhaseArray(NoPhaseFound_Index:) = 1000

END SUBROUTINE CalculateStapesPhase
